<?php

namespace App\Models;

use CodeIgniter\Model;

class ActivityModel extends Model
{
    protected $table            = 'activities';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'tanggal', 'jam', 'nama_aktivitas', 'deskripsi', 'foto', 'video',
        'created_at', 'updated_at'
    ];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    public function searchAndFilter($search = '', $filter = [], $sort = 'tanggal', $order = 'DESC')
    {
        $builder = $this->builder();

        if (!empty($search)) {
            $builder->groupStart()
                ->like('nama_aktivitas', $search)
                ->orLike('deskripsi', $search)
                ->groupEnd();
        }

        if (!empty($filter['tanggal_dari'])) {
            $builder->where('tanggal >=', $filter['tanggal_dari']);
        }

        if (!empty($filter['tanggal_sampai'])) {
            $builder->where('tanggal <=', $filter['tanggal_sampai']);
        }

        $allowedSorts = ['tanggal', 'jam', 'nama_aktivitas', 'created_at'];
        $sort = in_array($sort, $allowedSorts) ? $sort : 'tanggal';
        $order = strtoupper($order) === 'ASC' ? 'ASC' : 'DESC';

        $builder->orderBy($sort, $order);

        return $builder;
    }
}

